<?php

namespace App\Http\Controllers;


use Illuminate\Support\Facades\DB;
use App\Models\Package;
use App\Models\Module;
use App\Enums\PackageType;
use Froiden\Envato\Traits\AppBoot;
use Illuminate\Support\Facades\File;

class HomeController extends Controller
{

    use AppBoot;

    public function landing()
    {

        $this->showInstall();

        if (global_setting()->landing_site_type == 'custom') {
            return response(file_get_contents(global_setting()->landing_site_url));
        }

        $modules = Module::all();

        $packages = Package::with('modules')
            ->where('package_type', '!=', PackageType::DEFAULT)
            ->where('package_type', '!=', PackageType::TRIAL)
            ->where('is_private', false)
            ->get();

        $trialPackage = Package::where('package_type', PackageType::TRIAL)->first();


        return view('landing.index', compact('packages', 'modules', 'trialPackage'));
    }

    public function signup()
    {
        if (global_setting()->disable_landing_site) {
            return view('auth.restaurant_register');
        }

        return view('auth.restaurant_signup');
    }

    public function customerLogout()
    {
        session()->flush();
        return redirect('/');
    }

    public function manifest()
    {
        // Get request parameters and app name
        $hash = request()->query('hash', 'default_hash');

        if (!global_setting()) {
            $appName = 'Restaurant';
        } else {
            $appName = global_setting()->name;
        }


        // Define icon configurations
        $iconConfigs = [
            [
                'size' => '192x192',
                'path' => 'user-uploads/favicons/restaurant/android-chrome-192x192.png',
                'fallback' => 'img/192x192.png'
            ],
            [
                'size' => '512x512',
                'path' => 'user-uploads/favicons/restaurant/android-chrome-512x512.png',
                'fallback' => 'img/512x512.png'
            ]
        ];

        // Generate icon URLs with fallbacks
        $icons = array_map(function ($config) {
            $fullPath = public_path($config['path']);
            return [
                'src' => File::exists($fullPath) ? asset($config['path']) : asset($config['fallback']),
                'sizes' => $config['size'],
                'type' => 'image/png'
            ];
        }, $iconConfigs);

        // Return manifest JSON
        return response()->json([
            'name' => $appName,
            'short_name' => $appName,
            'description' => "$appName app",
            'start_url' => url("/restaurant/table/$hash"),
            'display' => 'standalone',
            'background_color' => '#ffffff',
            'theme_color' => '#000000',
            'icons' => $icons
        ]);
    }
}
